@extends('Template::layouts.master')

@section('content')
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card custom--card">
                <div class="card-header card-header-bg">
                    <h5 class="text-center"> <i class="las la-wallet"></i> {{ $data->gateway->name }} @lang('Payment')</h5>
                </div>
                <div class="card-body">
                    <form action="{{ route('user.deposit.manual.update') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <div class="row">
                            <div class="col-md-12">
                                <div class="alert alert--base">
                                    <div class="alert-icon">
                                        <i class="las la-info-circle"></i>
                                    </div>
                                    <div class="alert__content">
                                        <p class="mb-0">@lang('You are requesting') <b class="text--success">{{ showAmount($data['amount'])  }}</b> @lang('to deposit.') @lang('Please pay')
                                        <b class="text--success">{{showAmount($data['final_amount'],currencyFormat:false) .' '.$data['method_currency'] }} </b> @lang('for successful payment.')</p>
                                    </div>
                                </div>

                                <div class="mb-3">@php echo  $data->gateway->description @endphp</div>
                            </div>

                            <x-viser-form identifier="id" identifierValue="{{ $gateway->form_id }}" />

                            <div class="col-md-12">
                                <div class="form-group">
                                    <button type="submit" class="btn btn--base w-100 btn--lg">@lang('Pay Now')</button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
